package com.ejie.ab18a.utilidades;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import com.ejie.ab18a.envioBoletin.Ab18aEnvioBoletines;
import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.properties.Ab18aPropertiesBatchManager;

/**
 * The Class Ab18aConexionOracle.
 * 
 * @author XXXX
 */
public class Ab18aConexionOracle {

	/**
	 * Instantiates a new ab18a conexion oracle.
	 */
	private Ab18aConexionOracle() {
	}

	/**
	 * Conectar.
	 * 
	 * @param args
	 *            Datos de la conexion a base de datos
	 * @return the connection
	 * @throws Ab18aException
	 *             the ab18a exception
	 */
	public static synchronized Connection conectar(String[] args)
			throws Ab18aException {
		String nombre_metodo = "conectar";

		Connection conexion = null;

		String driver = "oracle.jdbc.driver.OracleDriver";
		String host = args[0];
		String puerto = Ab18aPropertiesBatchManager.getProperty("PUERTO");
		String ssid = Ab18aPropertiesBatchManager.getProperty("SSID");

		if (Ab18aUtils.notNullAndNotEmpty(puerto)
				&& Ab18aUtils.notNullAndNotEmpty(ssid)) {
			try {
				try {
					Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(),
							nombre_metodo, "Creamos instancia del Driver.", 1);
					Class.forName(driver).newInstance();
				} catch (InstantiationException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				} catch (ClassNotFoundException e) {
					e.printStackTrace();
				}
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(),
						nombre_metodo, "Creamos la conexion." + host + ":"
								+ puerto + ":" + ssid, 1);
				conexion = DriverManager.getConnection(host + ":" + puerto
						+ ":" + ssid, args[1], args[2]);
//				conexion = DriverManager.getConnection(host + ":" + puerto
//						+ ":" + ssid, usuario, password);
//				conexion = DriverManager.getConnection(hostDesa + ":" + puertoDesa
	//					+ "/" + ssid, usuario, password);
				Ab18aLog.debug(
						Ab18aEnvioBoletines.class.getName(),
						nombre_metodo,
						"conexion.getAutoCommit(): " + conexion.getAutoCommit(),
						1);
				conexion.setAutoCommit(false);
			} catch (SQLException e) {
				e.printStackTrace();
				conexion = null;
				throw new Ab18aException(Ab18aConexionOracle.class.getName(),
						nombre_metodo, e);
			}
		} else {
			conexion = null;
			throw new Ab18aException(Ab18aConexionOracle.class.getName(),
					nombre_metodo,
					"No se ha podido establecer la conexión con la BD");
		}

		return conexion;
	}

	/**
	 * Desconectar.
	 * 
	 * @param conexion
	 *            the conexion
	 * @throws Ab18aException
	 *             the y46j exception
	 */
	public static void desconectar(Connection conexion) throws Ab18aException {
		String nombre_metodo = "desconectar";
		
		Ab18aLog.configure("Ab18aEnvioBoletin", 1);
		try {
			if (conexion != null) {
				conexion.close();
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Conexión cerrada", 1);
			}
		} catch (SQLException e) {
			throw new Ab18aException(Ab18aConexionOracle.class.getName(),
					nombre_metodo, e);
		}
	}

	/**
	 * Commit.
	 * 
	 * @param conexion
	 *            the conexion
	 * @throws Ab18aException
	 *             the y46j exception
	 */
	public static void commit(Connection conexion) throws Ab18aException {
		String nombre_metodo = "commit";
		try {
			if (conexion != null) {
				conexion.commit();
			}
		} catch (SQLException e) {
			throw new Ab18aException(Ab18aConexionOracle.class.getName(),
					nombre_metodo, e);
		}
	}

	/**
	 * Rollback.
	 * 
	 * @param conexion
	 *            the conexion
	 * @throws Ab18aException
	 *             the y46j exception
	 */
	public static void rollback(Connection conexion) throws Ab18aException {
		String nombre_metodo = "rollback";
		try {
			if (conexion != null) {
				conexion.rollback();
			}
		} catch (SQLException e) {
			throw new Ab18aException(Ab18aConexionOracle.class.getName(),
					nombre_metodo, e);
		}
	}
}
